/********************************************
; File: MiscTool.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __MISCTOOL__
#define __MISCTOOL__


/* Error codes */
#define badInputErr 0x0301  /* bad input parameter */
#define noDevParamErr 0x0302  /* no device for input parameter */
#define taskInstlErr 0x0303  /* task already installed error */
#define noSigTaskErr 0x0304  /* no signature in task header */
#define queueDmgdErr 0x0305  /* queue has been damaged error */
#define taskNtFdErr 0x0306  /* task was not found error */
#define firmTaskErr 0x0307  /* firmware task was unsuccessful */
#define hbQueueBadErr 0x0308  /* heartbeat queue damaged */
#define unCnctdDevErr 0x0309  /* attempted to dispatch to unconnected device */
#define idTagNtAvlErr 0x030B  /* ID tag not available */
#define notInList 0x0380
#define invalidTag 0x0381  /* correct signature value not found in header */
#define alreadyInQueue 0x0382

/* System Fail Codes */
#define pdosUnClmdIntErr 0x0001  /* ProDOS unclaimed interrupt error */
#define divByZeroErr 0x0004  /* divide by zero error */
#define pdosVCBErr 0x000A  /* ProDOS VCB unusable */
#define pdosFCBErr 0x000B  /* ProDOS FCB unusable */
#define pdosBlk0Err 0x000C  /* ProDOS block zero allocated illegally */
#define pdosIntShdwErr 0x000D  /* ProDOS interrupt w/ shadowing off */
#define segLoader1Err 0x0015  /* segment loader error */
#define sPackage0Err 0x0017  /* can't load a package */
#define package1Err 0x0018  /* can't load a package */
#define package2Err 0x0019  /* can't load a package */
#define package3Err 0x001A  /* can't load a package */
#define package4Err 0x001B  /* can't load a package */
#define package5Err 0x001C  /* can't load a package */
#define package6Err 0x001D  /* can't load a package */
#define package7Err 0x001E  /* can't load a package */
#define package8Err 0x0020  /* can't load a package */
#define package9Err 0x0021  /* can't load a package */
#define package10Err 0x0022  /* can't load a package */
#define package11Err 0x0023  /* can't load a package */
#define package12Err 0x0024  /* can't load a package */
#define outOfMemErr 0x0025  /* out of memory error */
#define segLoader2Err 0x0026  /* segment loader error */
#define fMapTrshdErr 0x0027  /* file map trashed */
#define stkOvrFlwErr 0x0028  /* stack overflow error */
#define psInstDiskErr 0x0030  /* Please Insert Disk (file manager alert) */
#define memMgr1Err 0x0032  /* memory manager error */
#define memMgr2Err 0x0033  /* memory manager error */
#define memMgr3Err 0x0034  /* memory manager error */
#define memMgr4Err 0x0035  /* memory manager error */
#define memMgr5Err 0x0036  /* memory manager error */
#define memMgr6Err 0x0037  /* memory manager error */
#define memMgr7Err 0x0038  /* memory manager error */
#define memMgr8Err 0x0039  /* memory manager error */
#define memMgr9Err 0x003A  /* memory manager error */
#define memMgr10Err 0x003B  /* memory manager error */
#define memMgr11Err 0x003C  /* memory manager error */
#define memMgr12Err 0x003D  /* memory manager error */
#define memMgr13Err 0x003E  /* memory manager error */
#define memMgr14Err 0x003F  /* memory manager error */
#define memMgr15Err 0x0040  /* memory manager error */
#define memMgr16Err 0x0041  /* memory manager error */
#define memMgr17Err 0x0042  /* memory manager error */
#define memMgr18Err 0x0043  /* memory manager error */
#define memMgr19Err 0x0044  /* memory manager error */
#define memMgr20Err 0x0045  /* memory manager error */
#define memMgr21Err 0x0046  /* memory manager error */
#define memMgr22Err 0x0047  /* memory manager error */
#define memMgr23Err 0x0048  /* memory manager error */
#define memMgr24Err 0x0049  /* memory manager error */
#define memMgr25Err 0x004A  /* memory manager error */
#define memMgr26Err 0x004B  /* memory manager error */
#define memMgr27Err 0x004C  /* memory manager error */
#define memMgr28Err 0x004D  /* memory manager error */
#define memMgr29Err 0x004E  /* memory manager error */
#define memMgr30Err 0x004F  /* memory manager error */
#define memMgr31Err 0x0050  /* memory manager error */
#define memMgr32Err 0x0051  /* memory manager error */
#define memMgr33Err 0x0052  /* memory manager error */
#define memMgr34Err 0x0053  /* memory manager error */
#define stupVolMntErr 0x0100  /* can't mount system startup volume */

/* Battery Ram Parameter Reference Numbers */
#define p1PrntModem 0x0000
#define p1LineLnth 0x0001
#define p1DelLine 0x0002
#define p1AddLine 0x0003
#define p1Echo 0x0004
#define p1Buffer 0x0005
#define p1Baud 0x0006
#define p1DtStpBits 0x0007
#define p1Parity 0x0008
#define p1DCDHndShk 0x0009
#define p1DSRHndShk 0x000A
#define p1XnfHndShk 0x000B
#define p2PrntModem 0x000C
#define p2LineLnth 0x000D
#define p2DelLine 0x000E
#define p2AddLine 0x000F
#define p2Echo 0x0010
#define p2Buffer 0x0011
#define p2Baud 0x0012
#define p2DtStpBits 0x0013
#define p2Parity 0x0014
#define p2DCDHndShk 0x0015
#define p2DSRHndShk 0x0016
#define p2XnfHndShk 0x0017
#define dspColMono 0x0018
#define dsp40or80 0x0019
#define dspTxtColor 0x001A
#define dspBckColor 0x001B
#define dspBrdColor 0x001C
#define hrtz50or60 0x001D
#define userVolume 0x001E
#define bellVolume 0x001F
#define sysSpeed 0x0020
#define slt1intExt 0x0021
#define slt2intExt 0x0022
#define slt3intExt 0x0023
#define slt4intExt 0x0024
#define slt5intExt 0x0025
#define slt6intExt 0x0026
#define slt7intExt 0x0027
#define startupSlt 0x0028
#define txtDspLang 0x0029
#define kyBdLang 0x002A
#define kyBdBuffer 0x002B
#define kyBdRepSpd 0x002C
#define kyBdRepDel 0x002D
#define dblClkTime 0x002E
#define flashRate 0x002F
#define shftCpsLCas 0x0030
#define fstSpDelKey 0x0031
#define dualSpeed 0x0032
#define hiMouseRes 0x0033
#define dateFormat 0x0034
#define clockFormat 0x0035
#define rdMinRam 0x0036
#define rdMaxRam 0x0037
#define langCount 0x0038
#define lang1 0x0039
#define lang2 0x003A
#define lang3 0x003B
#define lang4 0x003C
#define lang5 0x003D
#define lang6 0x003E
#define lang7 0x003F
#define lang8 0x0040
#define layoutCount 0x0041
#define layout1 0x0042
#define layout2 0x0043
#define layout3 0x0044
#define layout4 0x0045
#define layout5 0x0046
#define layout6 0x0047
#define layout7 0x0048
#define layout8 0x0049
#define layout9 0x004A
#define layout10 0x004B
#define layout11 0x004C
#define layout12 0x004D
#define layout13 0x004E
#define layout14 0x004F
#define layout15 0x0050
#define layout16 0x0051
#define aTalkNodeNo 0x0080

/* GetAddr Parameter Reference Numbers */
#define irqIntFlag 0x0000
#define irqDataReg 0x0001
#define irqSerial1 0x0002
#define irqSerial2 0x0003
#define irqAplTlkHi 0x0004
#define tickCnt 0x0005
#define irqVolume 0x0006
#define irqActive 0x0007
#define irqSndData 0x0008
#define brkVar 0x0009
#define evMgrData 0x000A
#define mouseSlot 0x000B
#define mouseClamps 0x000C
#define absClamps 0x000D
#define sccIntFlag 0x000E

/* Hardware Interrupt Status Numbers */
#define extVGCInt 0x01  /* Returned by GetIRQEnable */
#define scanLineInt 0x02  /* Returned by GetIRQEnable */
#define adbDataInt 0x04  /* Returned by GetIRQEnable */
#define ADTBDataInt 0x04  /* maintained for compatiblity with old interfaces */
#define oneSecInt 0x10  /* Returned by GetIRQEnable */
#define quartSecInt 0x20  /* Returned by GetIRQEnable */
#define vbInt 0x40  /* Returned by GetIRQEnable */
#define kbdInt 0x80  /* Returned by GetIRQEnable */

/* Interrupt Reference Numbers */
#define kybdEnable 0x0000  /* Parameter to IntSource */
#define kybdDisable 0x0001  /* Parameter to IntSource */
#define vblEnable 0x0002  /* Parameter to IntSource */
#define vblDisable 0x0003  /* Parameter to IntSource */
#define qSecEnable 0x0004  /* Parameter to IntSource */
#define qSecDisable 0x0005  /* Parameter to IntSource */
#define oSecEnable 0x0006  /* Parameter to IntSource */
#define oSecDisable 0x0007  /* Parameter to IntSource */
#define adbEnable 0x000A  /* Parameter to IntSource */
#define adbDisable 0x000B  /* Parameter to IntSource */
#define scLnEnable 0x000C  /* Parameter to IntSource */
#define scLnDisable 0x000D  /* Parameter to IntSource */
#define exVCGEnable 0x000E  /* Parameter to IntSource */
#define exVCGDisable 0x000F  /* Parameter to IntSource */

/* Mouse Mode Values */
#define mouseOff 0x0000
#define transparent 0x0001
#define transParnt 0x0001  /* (old name) */
#define moveIntrpt 0x0003
#define bttnIntrpt 0x0005
#define bttnOrMove 0x0007
#define mouseOffVI 0x0008
#define transParntVI 0x0009  /* (old name) */
#define transparentVI 0x0009
#define moveIntrptVI 0x000B
#define bttnIntrptVI 0x000D
#define bttnOrMoveVI 0x000F

/* Vector Reference Numbers */
#define toolLoc1 0x0000
#define toolLoc2 0x0001
#define usrTLoc1 0x0002
#define usrTLoc2 0x0003
#define intrptMgr 0x0004
#define copMgr 0x0005
#define abortMgr 0x0006
#define _sysFailMgr 0x0007
#define aTalkIntHnd 0x0008
#define sccIntHnd 0x0009
#define scLnIntHnd 0x000A
#define sndIntHnd 0x000B
#define vblIntHnd 0x000C
#define mouseIntHnd 0x000D
#define qSecIntHnd 0x000E
#define kybdIntHnd 0x000F
#define adbRBIHnd 0x0010
#define adbSRQHnd 0x0011
#define deskAccHnd 0x0012
#define flshBufHnd 0x0013
#define kybdMicHnd 0x0014
#define oneSecHnd 0x0015
#define extVCGHnd 0x0016
#define otherIntHnd 0x0017
#define crsrUpdtHnd 0x0018
#define incBsyFlag 0x0019
#define decBsyFlag 0x001A
#define bellVector 0x001B
#define breakVector 0x001C
#define traceVector 0x001D
#define stepVector 0x001E
#define ctlYVector 0x0028
#define proDOSVector 0x002A
#define proDOSVctr 0x002A  /* for backward compatibility */
#define osVector 0x002B
#define msgPtrVector 0x002C
#define msgPtrVctr 0x002C  /* for backward compatibility */
#define memMoverVector 0x0080
#define sysSpeedVector 0x0081
#define slotArbiterVector 0x0082
#define hiInterruptVector 0x0086
#define midiInterruptVector 0x0087
struct ClampRec {
   Word yMaxClamp; /*  */
   Word yMinClamp; /*  */
   Word xMaxClamp; /*  */
   Word xMinClamp; /*  */
} ;
typedef struct ClampRec ClampRec, *ClampRecPtr, **ClampRecHndl;
struct FWRec {
   Word yRegExit; /*  */
   Word xRegExit; /*  */
   Word aRegExit; /*  */
   Word status; /*  */
} ;
typedef struct FWRec FWRec, *FWRecPtr, **FWRecHndl;
struct MouseRec {
   Byte mouseMode; /*  */
   Byte mouseStatus; /*  */
   Word yPos; /*  */
   Word xPos; /*  */
} ;
typedef struct MouseRec MouseRec, *MouseRecPtr, **MouseRecHndl;
struct InterruptStateRec {
   Word irq_A;
   Word irq_X;
   Word irq_Y;
   Word irq_S;
   Word irq_D;
   Byte irq_P;
   Byte irq_DB;
   Byte irq_e;
   Byte irq_K;
   Word irq_PC;
   Byte irq_state;
   Word irq_shadow;
   Byte irq_mslot;
} ;
typedef struct InterruptStateRec InterruptStateRec, *InterruptStateRecPtr, **InterruptStateRecHndl;
struct QueueHeaderRec {
   struct QueueHeaderRec *qNext; /*   */
   Word reserved; /*   */
   Word signature; /* Validates header - must be $A55A  */
} ;
typedef struct QueueHeaderRec QueueHeaderRec, *QueueHeaderRecPtr;
extern pascal void AddToQueue() inline(0x2E03,dispatcher);
extern pascal void ClampMouse() inline(0x1C03,dispatcher);
extern pascal void ClearMouse() inline(0x1B03,dispatcher);
extern pascal void ClrHeartBeat() inline(0x1403,dispatcher);
extern pascal void DelHeartBeat() inline(0x1303,dispatcher);
extern pascal void DeleteFromQueue() inline(0x2F03,dispatcher);
extern pascal void DeleteID() inline(0x2103,dispatcher);
extern FWRec FWEntry();
extern ClampRec GetAbsClamp();
extern pascal Pointer GetAddr() inline(0x1603,dispatcher);
extern pascal ProcPtr GetCodeResConverter() inline(0x3403,dispatcher);
extern pascal Word GetIRQEnable() inline(0x2903,dispatcher);
extern pascal Word GetIntStateRecSize() inline(0x3203,dispatcher);
extern pascal void GetInterruptState() inline(0x3103,dispatcher);
extern ClampRec GetMouseClamp();
extern pascal Word GetNewID() inline(0x2003,dispatcher);
extern pascal Pointer GetRomResource() inline(0x3503,dispatcher);
extern pascal LongWord GetTick() inline(0x2503,dispatcher);
extern pascal Pointer GetVector() inline(0x1103,dispatcher);
extern pascal void HomeMouse() inline(0x1A03,dispatcher);
extern pascal void InitMouse() inline(0x1803,dispatcher);
extern pascal void IntSource() inline(0x2303,dispatcher);
extern pascal void MTBootInit() inline(0x0103,dispatcher);
extern pascal void MTReset() inline(0x0503,dispatcher);
extern pascal void MTShutDown() inline(0x0303,dispatcher);
extern pascal void MTStartUp() inline(0x0203,dispatcher);
extern pascal Boolean MTStatus() inline(0x0603,dispatcher);
extern pascal Word MTVersion() inline(0x0403,dispatcher);
extern pascal Word Munger() inline(0x2803,dispatcher);
extern pascal Word PackBytes() inline(0x2603,dispatcher);
extern pascal void PosMouse() inline(0x1E03,dispatcher);
extern pascal void ReadAsciiTime() inline(0x0F03,dispatcher);
extern pascal Word ReadBParam() inline(0x0C03,dispatcher);
extern pascal void ReadBRam() inline(0x0A03,dispatcher);
extern MouseRec ReadMouse();
extern MouseRec ReadMouse2();
extern TimeRec ReadTimeHex();
extern pascal void ReleaseRomResource() inline(0x3603,dispatcher);
extern pascal Word ServeMouse() inline(0x1F03,dispatcher);
extern void SetAbsClamp();
extern pascal void SetHeartBeat() inline(0x1203,dispatcher);
extern pascal void SetInterruptState() inline(0x3003,dispatcher);
extern pascal void SetMouse() inline(0x1903,dispatcher);
extern pascal void SetVector() inline(0x1003,dispatcher);
extern pascal void StatusID() inline(0x2203,dispatcher);
extern pascal void SysBeep() inline(0x2C03,dispatcher);
extern pascal void SysFailMgr() inline(0x1503,dispatcher);
extern pascal Word UnPackBytes() inline(0x2703,dispatcher);
extern pascal void WriteBParam() inline(0x0B03,dispatcher);
extern pascal void WriteBRam() inline(0x0903,dispatcher);
extern void WriteTimeHex();
#endif
